#!/bin/sh
LOGGER="/usr/bin/logger"
SERVICE_NAME="synoproxyserver"
KERNEL_MODULES_NAT="nf_nat.ko iptable_nat.ko ipt_REDIRECT.ko ipt_MASQUERADE.ko"
KERNEL_MODULES_CORE="x_tables.ko ip_tables.ko iptable_filter.ko nf_conntrack.ko nf_defrag_ipv4.ko nf_conntrack_ipv4.ko ipt_LOG.ko"
KERNEL_MODULES_COMMON="xt_multiport.ko xt_tcpudp.ko xt_state.ko xt_limit.ko xt_iprange.ko"
KERNEL_MODULES_TOTAL="${KERNEL_MODULES_CORE} ${KERNEL_MODULES_NAT} ${KERNEL_MODULES_COMMON}"

reverse_syno() {
        local modules=$1
        local mod
        local ret=""

        for mod in $modules; do
                ret="$mod $ret"
        done

        echo $ret
}


log_msg()
{
        $LOGGER -s warn -t "Proxy Server" "$1"
}
load_kernel_module()
{
        /usr/syno/bin/synomoduletool --insmod ${SERVICE_NAME} ${KERNEL_MODULES_TOTAL}
}
unload_kernel_module()
{
        MODULES_REVERSE=`reverse_syno "${KERNEL_MODULES_TOTAL}"`
        /usr/syno/bin/synomoduletool --rmmod ${SERVICE_NAME} ${MODULES_REVERSE}
}
add_rule()
{
        load_kernel_module

        local IPADDR=$1
        local NETMASK=$2
        local IFNAME=$3
        local SQUID_PORT=`/bin/cat /var/packages/Squid/target/squid/etc/general_setting_syno.conf  | /bin/grep http_port | /usr/bin/awk '{print $2}'`
        NETWORK=`/bin/ipcalc -n ${IPADDR} ${NETMASK} | /usr/bin/awk -F = '{print $2}'` # set $NETWORK
        PREFIX=`/bin/ipcalc -p ${IPADDR} ${NETMASK} | /usr/bin/awk -F = '{print $2}'` # set $PREFIX
        /sbin/iptables -t nat -I PREROUTING -i $IFNAME -s ${NETWORK}/${PREFIX} -p tcp --dport 80 -j REDIRECT --to-ports $SQUID_PORT
}
remove_rule()
{
        local SQUID_PORT=`/bin/cat /var/packages/Squid/target/squid/etc/general_setting_syno.conf  | /bin/grep http_port | /usr/bin/awk '{print $2}'`
        /sbin/iptables -t nat -S PREROUTING | /bin/grep $SQUID_PORT | /usr/bin/cut -d " " -f 3- | while read line
        do 
                /sbin/iptables -t nat -D PREROUTING $line
        done

        unload_kernel_module || true  #XXX unload module may return value>0, WR

}
case $1 in
        --add)
        shift
        add_rule $@
        ;;
        --remove)
        remove_rule
        ;;
esac
