#!/bin/sh

PKG_STR_WIZARD_UPGRADE_TITLE="Lesen Sie, bevor Sie fortfahren"
PKG_STR_WIZARD_UPGRADE_NOTE="Das Upgrade auf Surveillance Station erfordert eine Konvertierung der Datenbank, und kann somit abhängig von der Anzahl der Aufnahmen in der Datenbank eine Weile dauern. Bitte warten Sie und fahren Sie das System nicht herunter oder deinstallieren Sie das Paket nicht während dieses Prozesses."
PKG_STR_WIZARD_UPGRADE_VS_60_80_NOTE="Diese Version von Surveillance Station ist nur mit VisualStation {0} und höher kompatibel. Die Modelle VisualStation VS60 und VS80 werden von dieser Version von Surveillance Station nicht mehr unterstützt."
PKG_STR_WIZARD_UPGRADE_VS_360HD_NOTE="Nachdem die VS360HD auf Version 4.0 und höher aktualisiert wurde, wird die ursprüngliche Kopplungsfunktion der Visual Station durch den neuen Anmeldemechanismus ersetzt. Sie können sich direkt über Ihre Synology VisualStation VS360HD auf der Surveillance Station anmelden. Außerdem werden die gesamten Funktionen für Netzwerk-Videoaufnahmen der Surveillance Station jetzt auf der VS360HD unterstützt.<br><br>Die aktuelle Version der Surveillance Station ist kompatibel mit der ursprünglichen Kopplungsfunktion der VisualStation Version 3.0.5 und dem neuen Anmeldemechanismus der VisualStation Version 4.0. Die ursprüngliche Kopplungsfunktion endet jedoch mit den nächsten Aktualisierungen."
PKG_STR_WIZARD_UPGRADE_PSIA_NOTE="Surveillance Station unterstützt PSIA ab dieser Version nicht mehr. Sie können keine Kameras mehr verwenden, die mit PSIA in der Surveillance Station eingerichtet wurden."
PKG_STR_WIZARD_INCOMPATIBLE_CHECK_LABEL="Ich verstehe die Kompatibilitätseinschränkungen und möchte mit der Aktualisierung fortfahren."

# Copyright (c) 2015 Synology Inc. All rights reserved.

SS_PKG_PATH="/var/packages/SurveillanceStation/"
SS_INFO_FILE=${SS_PKG_PATH}"INFO"
SS_SYSTEM_DB_FILE=${SS_PKG_PATH}"target/system.db"
SS_VER_KEY="version"
SS_SQLITE3_VER="6.3"
SS_THUMBNAIL_ISSUE_BUILD_VER="3312"
SS_THUMBNAIL_FIXED_BUILD_VER="3352"
VS_MODELS_60_80="'VS60', 'VS80'"
VS_MODELS_360HD="'VS360HD'"
VS_360HD_NEW_LOGIN_MECHANISM_MIN_VERSION="'4.0'"
SS_UNSUPPORT_VENDOR="('PSIA')"
SS_MIN_VS_60_80_VERSION="2.2-1413"
SS_MIN_VS_360_VERSION="3.1-2500"
SS_SQLITE3="${SS_PKG_PATH}target/bin/sqlite3"
DEF_SQLITE3="/usr/syno/bin/sqlite3"
FN_CHECK_BOX_VALIDATOR="{ var blChecked = arguments[0]; return true === blChecked; }"

UPGRADE_VS_60_80_NOTE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"invalid_next_disabled": true,
	"items": [{
		"type": "multiselect",
		"desc": "$(echo $PKG_STR_WIZARD_UPGRADE_VS_60_80_NOTE | sed "s/{0}/${SS_MIN_VS_60_80_VERSION}/g")",
		"subitems": [{
			"desc": "${PKG_STR_WIZARD_INCOMPATIBLE_CHECK_LABEL}",
			"validator": {
				"fn": "$FN_CHECK_BOX_VALIDATOR"
			}
		}]
	}]
}
EOF`

UPGRADE_VS_360_NOTE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
    "items": [{
        "desc": "$PKG_STR_WIZARD_UPGRADE_VS_360HD_NOTE"
    }]
}
EOF`

UPGRADE_PSIA_NOTE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"invalid_next_disabled": true,
	"items": [{
		"type": "multiselect",
		"desc": "${PKG_STR_WIZARD_UPGRADE_PSIA_NOTE}",
		"subitems": [{
			"desc": "${PKG_STR_WIZARD_INCOMPATIBLE_CHECK_LABEL}",
			"validator": {
				"fn": "$FN_CHECK_BOX_VALIDATOR"
			}
		}]
	}]
}
EOF`

UPGRADE_DB_NOTE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"invalid_next_disabled": true,
	"items": [{
		"desc": "${PKG_STR_WIZARD_UPGRADE_NOTE}"
	}]
}
EOF`

Sqlite3Exec()
{
	local sqlite_bin=""
	if [ -f "$SS_SQLITE3" ]; then
		sqlite_bin=$SS_SQLITE3
	else
		sqlite_bin=$DEF_SQLITE3
	fi

	$sqlite_bin -init /dev/null -cmd ".timeout 300000" "$@"
}

IsUpgradeToSqlite3()
{
	local PreSSVer=$(/bin/get_key_value "${SS_INFO_FILE}" "${SS_VER_KEY}" | cut -d '-' -f 1)

	if [ ${SS_SQLITE3_VER} \> ${PreSSVer} ]; then
		echo "true"
	else
		echo "false"
	fi
}

IsUpgradeThumbnailToFile()
{
	local PreSSBuildVer=$(/bin/get_key_value "${SS_INFO_FILE}" "${SS_VER_KEY}" | cut -d '-' -f 2)

	if [ ${SS_THUMBNAIL_ISSUE_BUILD_VER} -le ${PreSSBuildVer} ] && [ ${SS_THUMBNAIL_FIXED_BUILD_VER} -gt ${PreSSBuildVer} ]; then
		echo "true"
	else
		echo "false"
	fi
}

HasVS()
{
	local Models="$1"
	local MinVersion="$2"
	local SqlCmd="SELECT COUNT(*) FROM visualstation WHERE platform IN ($Models)"

	if [ -n "$MinVersion" ]; then
		SqlCmd="SELECT COUNT(*) FROM visualstation WHERE platform IN ($Models) AND version < $MinVersion"
	else
		SqlCmd="SELECT COUNT(*) FROM visualstation WHERE platform IN ($Models)"
	fi

	CheckSystemDBItemExist "${SqlCmd}"
}

HasPsiaCam()
{
	local SqlCmd="SELECT COUNT(*) FROM camera WHERE vendor IN ${SS_UNSUPPORT_VENDOR}"

	CheckSystemDBItemExist "${SqlCmd}"
}

CheckSystemDBItemExist()
{
	local SqlCmd="$1"
	local Cnt=$(Sqlite3Exec $SS_SYSTEM_DB_FILE "$SqlCmd")

	if [ -z "${Cnt}" ]; then
		Cnt=$(/usr/syno/pgsql/bin/psql -A -t -U postgres surveillance -c "${SqlCmd}")
	fi

	if [ ${Cnt} -gt 0 ]; then
		echo "true"
	else
		echo "false"
	fi
}

GetUpgradeNotePages()
{
	local Pages=""

	if [ "true" == $(HasPsiaCam) ]; then
		Pages="${UPGRADE_PSIA_NOTE_PAGE}"
	fi

	if [ "true" == $(HasVS "$VS_MODELS_60_80") ]; then
		[ -z "$Pages" ] && Pages="${UPGRADE_VS_60_80_NOTE_PAGE}" \
						|| Pages="${Pages},${UPGRADE_VS_60_80_NOTE_PAGE}"
	fi

	if [ "true" == $(HasVS "$VS_MODELS_360HD" "$VS_360HD_NEW_LOGIN_MECHANISM_MIN_VERSION") ]; then
		[ -z "$Pages" ] && Pages="${UPGRADE_VS_360_NOTE_PAGE}" \
				        || Pages="${Pages},${UPGRADE_VS_360_NOTE_PAGE}"
	fi

	if [ "true" == $(IsUpgradeToSqlite3) ] || [ "true" == $(IsUpgradeThumbnailToFile) ]; then
		[ -z "$Pages" ] && Pages="${UPGRADE_DB_NOTE_PAGE}" \
				        || Pages="${Pages},${UPGRADE_DB_NOTE_PAGE}"
	fi

	echo "[$Pages]"
}

main()
{
	local UpgradeNotePages="$(GetUpgradeNotePages)"

	if [ "[]" == "$UpgradeNotePages" ]; then
		exit 0
	fi

	echo "$UpgradeNotePages" > $SYNOPKG_TEMP_LOGFILE

	exit 0
}

main "$@"
